package gov.va.genisis2.dao.impl;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;

import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.dao.IHibernateDao;
import gov.va.genisis2.exceptions.GenisisDAOException;

public abstract class AbstactHibernateDao implements IHibernateDao {

	/**
	 * The LOGGER.
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(AbstactHibernateDao.class);

	/**
	 * Max row value.
	 *
	 * @return int This returns entity's next id.
	 */
	@Override
	public <T> int getMaxRowValue(Session session, Class<T> persistentClass, String propertyName) {
		int maxRowVal = 1;
		Number number = null;
		CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
		CriteriaQuery<Number> criteriaQuery = criteriaBuilder.createQuery(Number.class);
		Root<T> root = criteriaQuery.from(persistentClass);

		try {
			criteriaQuery.select(criteriaBuilder.max(root.<Number>get(propertyName)));
			number = session.createQuery(criteriaQuery).getSingleResult();
		} catch (Exception ex) {
			LOGGER.error("Exception occured on getMaxRowValue().", ex);
		}

		if (number != null) {
			maxRowVal = number.intValue() + 1;
		}

		return maxRowVal;
	}

	/**
	 * This method is used to submit Or Modify entity.
	 * 
	 */
	@Override
	public int createData(Session session, Object entity) throws GenisisDAOException {
		Integer id = 0;
		
		try {
			id = (Integer) session.save(entity);
			session.flush();
		} catch (Exception ex) {
			LOGGER.error("Exception occured in createData", ex);
			throw new GenisisDAOException("Exception occured in createData", ex);
		}

		return id.intValue();
	}
	
	/**
	 * This method is used to modify entity details.
	 * 
	 */
	@Override
	public Object updateData(Session session, Object entity) throws GenisisDAOException {

		try {
			session.saveOrUpdate(entity);
			session.flush();
		} catch (Exception ex) {
			LOGGER.error("Exception occured in submitOrModify", ex);
			throw new GenisisDAOException("Exception occured in submitOrModify", ex);
		}

		return entity;
	}
}
